<?php
require_once("Main_model.php");

class Designation_model extends Main_model
{
    private $tableName = 'designation';
    private $join = 'comp';
    private $comp;

    public function _construct()
    {
        //$this->load->database();
    }

    /*
    Determines if a given string is an exists
    */
    function exists($var)
    {
        if ($var) {
            return true;
        } else {
            return false;
        }
    }

    function count_all($id = 0)
    {
        $this->db->from($this->tableName);
        if ($id != 0) {
            $this->db->where('Code', $id);
        }
        return $this->db->count_all_results();
    }

    function get_all()
    {
        $this->db->select('*');
        $this->db->from("designation");
        $query = $this->db->get();
        return $query->result();
    }

    function get_info($id = '',$comp)
    {
        $this->db->select('*');
        $this->db->from($this->tableName);
        $this->db->where('Id', $id);
        $this->db->where('Comp', $comp);
        $query = $this->db->get();
        if ($query->num_rows() == 1) {
            return $query->row();
        } else {
            return false;
        }
    }

    /*
    Inserts or updates a page
    */
    function save(&$data, $id = false)
    {
        if (!$id) {
            if (!$this->exist_designation($data['Name'],$data['Comp'])) {
                if ($this->db->insert($this->tableName, $data)) {
                    return true;
                }
            }
            return false;
        }
        $this->db->where('Id', $id);
        return $this->db->update($this->tableName, $data);
    }

    function AddRecord(&$data)
    {
        if ($this->db->insert($this->tableName, $data)) {
            return true;
        }
    }

    function editRecord(&$data, $id = false)
    {
        $this->db->where('Id', $id);
        return $this->db->update($this->tableName, $data);
    }

    function exist_designation($Name,$Comp)
    {
        $this->db->from($this->tableName);
        $this->db->where('Name', $Name);
        $this->db->where('Comp', $Comp);
        //$this->db->where('Status',1);
        $query = $this->db->get();
        if ($query->num_rows() == 1) {
            $this->messages->add('Designation already exist', "error");
            return true;
        } else {
            return false;
        }
    }

    /*Deletes one company*/
    function delete($Dep_code, $comp_id)
    {
        $this->db->where('Dep_code', $Dep_code);
        $this->db->where('Comp_Id', $comp_id);
        return $this->db->delete($this->tableName);
    }
}
?>