<?php
require_once("Main_model.php");
class items_model extends Main_model
{
	private $tableName = 'items';
	private $join = 'comp';
	private $comp;

	public function _construct()
	{
		//$this->load->database();
	}

	/*
	   Determines if a given string is an exists
	   */
	function exist($var)
	{
		if ($var) {
			return true;
		} else {
			return false;
		}
	}

	function exist_row($where)
	{
		$this->db->from($this->tableName);
		$this->db->where($where);
		$query = $this->db->get();
		if ($query->num_rows() == 1) {
			return true;
		} else {
			return false;
		}
	}

	function count_all($id = 0)
	{
		$this->db->from($this->tableName);
		if ($id != 0) {
			$this->db->where('Code', $id);
		}
		return $this->db->count_all_results();
	}

	/*
	   Returns all the companys
	   */
	function get_all($type = '', $comp='')
	{
		$this->db->select('t.*,t.Name as ItemName, jt.Name');
		$this->db->from($this->tableName . " AS t");
		$this->db->join($this->join . ' AS jt', 't.Comp = jt.Code', 'left');
		if ($type != '')
			$this->db->where_in('t.Id', $type);
		if ($comp != '')
			$this->db->where('t.Comp', $comp);
		$query = $this->db->get();
		return $query->result();
	}

	function get_all_by_id($id = 'A', $bas = 'no', $fix = 'no')
	{
		$this->db->select('t.*');
		$this->db->from($this->tableName . " AS t");
		$this->db->where('t.Id', $id);
		//$this->db->where('t.Fix',$fix);
		//$this->db->where('t.Basic',$bas);
		$query = $this->db->get();
		return $query->result();
	}

	function get_all_by_type($id = 'A')
	{
		$this->db->select('t.*');
		$this->db->from($this->tableName . " AS t");
		$this->db->where('t.Id', $id);
		$this->db->where('t.Fix', 'yes');
		$query = $this->db->get();
		//echo $this->db->last_query();
		return $query->result();
	}

	function get_info($where = array())
	{
		$this->db->select('*');
		$this->db->from($this->tableName);
		$this->db->where($where);
		$query = $this->db->get();
		if ($query->num_rows() == 1) {
			return $query->row();
		} else {
			return false;
		}
	}

	/*
	   Inserts or updates a page
	   */
	function save(&$data, $where = array())
	{
		if (!$this->exist_row($where)) {
			if ($this->db->insert($this->tableName, $data)) {
				return true;
			}
			return false;
		}
		$this->db->where($where);
		return $this->db->update($this->tableName, $data);
	}

	/*
	   Deletes one company
	   */
	function delete($id)
	{
		if ($this->delete_image($id)) {
			$this->db->where('Code', $id);
			//$this->db->where('Comp_Id', $this->attn->getComp());

			return $this->db->delete($this->tableName);
		}
		return false;
	}

	public function change_status($company_code, $comp = 'dp')
	{
		$this->db->trans_start();
		$this->db->from('employee');
		$this->db->where('Comp', $comp);
		$this->db->where('Dep_code', $company_code);
		$this->db->where('Active', 1);
		$count = $this->db->count_all_results();
		$this->db->trans_complete();
		if ($count == 0) {
			$this->db->trans_start();
			$this->db->where('Dep_code', $company_code);
			$this->db->where('Comp_Id', $comp);
			$this->db->update($this->tableName, array('Status' => 0));
			echo $this->db->last_query();
			//return $this->db->affected_rows();
			$return = (bool) ($this->db->affected_rows() > 0);
			$this->db->trans_complete();
			return $return;
		} else {
			$this->messages->add($this->lang->line('error_company_delete'), "error");
			return false;
		}
	}
}