<?php
/**
 * Created by PhpStorm.
 * User: Namal
 * Date: 11/30/2017
 * Time: 1:22 PM
 */
require_once(APPPATH."models/Main_model.php");

class Payslip_model extends Main_model
{

    function __construct()
    {
        parent::__construct();
    }

    public function get_all_employee_filter($emp=0)
    {
        $nemp = ($emp!=0)? " AND E.EmpNo='".$emp."'":'';
        //$query = $this->db->query("SELECT EmpNo,EmpName,Basic_Salery FROM `employee` WHERE Comp=".$this->db->escape($comp)." AND Active='1' $nemp ORDER BY EmpNo ASC");
        $query = $this->db->query("SELECT E.EmpNo,E.EPFNo,E.EmpName,E.Title,E.Bank,E.Branch,E.BankCode,E.BranchCode,E.AccountNo,E.Month_working_days,D.Description AS Department,S.Name AS Designation FROM `employee` AS E 
        LEFT JOIN department D ON (E.Dep_code=D.Dep_code)
        LEFT JOIN designation S ON (E.Designation=S.Id) 
        WHERE Active='1' $nemp ORDER BY EmpNo ASC");
        //echo $this->db->last_query(); die();
        return $query->result();
    }

    public function get_all_employees($comp, $emp=0)
    {
        $query = $this->db->query("SELECT EmpNo,EmpName,Basic_Salery FROM `employee` WHERE Comp=".$this->db->escape($comp)." AND Active='1' ORDER BY EmpNo ASC");
        return $query->result();
    }

    public function get_items($month)
    {
        $query = $this->db->query("SELECT t.*,i.Name,i.EPF,i.Basic,i.Rate as IRate FROM `trans` as t 
		LEFT JOIN items AS i
		ON t.Item_Code=i.Code AND t.Id_Item=i.Id
		 WHERE t.month=".$this->db->escape($month)." ORDER BY t.EmpNo,i.Name");
        //t.EmpNo=".$this->db->escape($id)." AND
        //echo $this->db->last_query(); die();
        return $query->result_array();
    }

    public function get_payroll()
    {
        $this->db->select('*');
        $this->db->from("payroll");
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            $data = array();
            foreach($query->result_array() as $row){
                $data[$row['EmpNo']] = $row;
            }
            return $data;
        }
        else
        {
            return false;
        }
    }


    public function get_increment()
    {
        $this->db->select('EmpNo,SUM(`Amount`) AS Amount',FALSE);
        $this->db->from("increment");
        $this->db->group_by("EmpNo");
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            $data = array();
            foreach($query->result_array() as $row){
                $data[$row['EmpNo']] = $row['Amount'];
            }
            return $data;
        }
        else
        {
            return false;
        }
    }

     public function get_month_salary_by_employees($comp=NULL,$month=NULL)
    {
        $this->db->select('p.salaryPayable,e.EPFNo,e.EmpNo,e.IDNo,e.AccountNo,e.Bank,e.Branch,e.AccountName,e.BankCode,e.BranchCode');
        $this->db->from("payslip AS p");
        $this->db->join('employee AS e', 'p.Comp = e.Comp AND p.EmpNo=e.EmpNo','left');
        $this->db->where('p.Month',$month);
        $this->db->where('p.Comp',$comp);
        $this->db->where('e.Comp',$comp);
        $this->db->order_by('ABS(e.EPFNo)','ASC');
        $query = $this->db->get();
        //echo $this->db->last_query();
        if($query->num_rows() > 0)
        {
            $data = array();
            foreach($query->result() as $row){
                $data[] = $row;
            }
            return $data;
        }
        else
        {
            return false;
        }
    }

    public function get_trns_by_employees($comp=NULL,$month=NULL,$Code=NULL)
    {
        $this->db->select('t.*,e.EPFNo,e.EmpNo,e.IDNo,e.EmpName');
        $this->db->from("trans AS t");
        $this->db->join('employee AS e', 't.Comp = e.Comp AND t.EmpNo=e.EmpNo','left');
        $this->db->where('t.month',$month);
        $this->db->where('t.Comp',$comp);
        $this->db->where('e.Comp',$comp);
        $this->db->where('t.Item_Code',$Code);
        $this->db->order_by('e.EmpNo','ASC');
        $query = $this->db->get();
        //echo $this->db->last_query();
        if($query->num_rows() > 0)
        {
            $data = array();
            foreach($query->result() as $row){
                $data[] = $row;
            }
            return $data;
        }
        else
        {
            return false;
        }
    }


   


    public function get_month_epf_by_employees($month=NULL)
    {
        $this->db->select('p.salaryPayable,e.EPFNo,e.EmpNo,e.IDNo,e.AccountNo,e.Bank,e.Branch,e.AccountName,p.EPF,e.IDNo,e.EmpName,p.EPFepm');
        $this->db->from("payslip AS p");
        $this->db->join('employee AS e', 'p.EmpNo=e.EmpNo','left');
        $this->db->where('p.Month',$month);
        // $this->db->where('p.Comp',$comp);
        //$this->db->where('e.Comp',$comp);
        $this->db->where("e.EPFNo !=''");
        $this->db->order_by('ABS(e.EPFNo)','ASC');
        $query = $this->db->get();
        //echo $this->db->last_query();
        if($query->num_rows() > 0)
        {
            $data = array();
            foreach($query->result() as $row){
                $data[] = $row;
            }
            return $data;
        }
        else
        {
            return false;
        }
    }

    public function get_month_etf_by_employees($month=NULL)
    {
        $this->db->select('p.salaryPayable,e.EPFNo,e.EmpNo,e.IDNo,e.AccountNo,e.Bank,e.Branch,e.AccountName,p.ETF,e.IDNo,e.EmpName');
        $this->db->from("payslip AS p");
        $this->db->join('employee AS e', 'p.EmpNo=e.EmpNo','left');
        $this->db->where('p.Month',$month);
        //$this->db->where('p.Comp',$comp);
        //$this->db->where('e.Comp',$comp);
        $this->db->where("e.EPFNo !=''");
        $this->db->order_by('ABS(e.EPFNo)','ASC');
        $query = $this->db->get();
        //echo $this->db->last_query();
        if($query->num_rows() > 0)
        {
            $data = array();
            foreach($query->result() as $row){
                $data[] = $row;
            }
            return $data;
        }
        else
        {
            return false;
        }
    }

    public function get_month_allowance_deduction($comp,$month,$item,$Item_Code)
    {
        $this->db->select('p.AllowancesForBasic,p.AllowanceString,p.DeductionsForBasic,p.DeductionString,e.EPFNo,e.EmpNo,e.EmpName');
        $this->db->from("payslip AS p");
        $this->db->join('employee AS e', 'p.Comp = e.Comp AND p.EmpNo=e.EmpNo','left');
        $this->db->where('p.Month',$month);
        $this->db->where('p.Comp',$comp);
        $this->db->where('e.Comp',$comp);
        $this->db->where("e.EPFNo !=''");
        $this->db->order_by('ABS(e.EPFNo)','ASC');
        $query = $this->db->get();
        //echo $this->db->last_query();
        $records = array();
        if($query->num_rows() > 0)
        {
            foreach($query->result() as $row){
                $allowances_deductions = array();
                $AllowancesForBasic = unserialize($row->AllowancesForBasic);
                foreach ($AllowancesForBasic as $afb){
                    $allowances_deductions[$afb[2]."-".$afb[4]] = $afb;
                }
                $AllowanceString = unserialize($row->AllowanceString);
                foreach ($AllowanceString as $as){
                    $allowances_deductions[$as[2]."-".$as[4]] = $as;
                }

                $DeductionsForBasic = unserialize($row->DeductionsForBasic);
                foreach ($DeductionsForBasic as $dfb){
                    $allowances_deductions[$dfb[2]."-".$dfb[4]] = $dfb;
                }
                $DeductionString = unserialize($row->DeductionString);
                foreach ($DeductionString as $ds){
                    $allowances_deductions[$ds[2]."-".$ds[4]] = $ds;
                }
                foreach ($allowances_deductions as $key=>$value){
                    if($key==$item."-".$Item_Code) {
                        $value[5] = $row->EmpName;
                        $value[6] = $row->EPFNo;
                        $value[7] = $row->EmpNo;
                        $records[$row->EPFNo] = $value;
                    }
                }
            }
            return $records;
        }
        else
        {
            return false;
        }
    }

    public function get_month_denomination_by_employees($comp=NULL,$month=NULL)
    {
        $this->db->select('p.EmpNo,p.salaryPayableRound,e.EmpName,e.IDNo,e.AccountNo');
        $this->db->from("payslip AS p");
        $this->db->join('employee AS e', 'p.Comp = e.Comp AND p.EmpNo=e.EmpNo','left');
        $this->db->where('p.Month',$month);
        $this->db->where('p.Comp',$comp);
        $this->db->where('e.Comp',$comp);
        $this->db->order_by('e.EmpNo','ASC');
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            $data = array();
            foreach($query->result() as $row){
                $data[] = $row;
            }
            return $data;
        }
        else
        {
            return false;
        }
    }

    public function get_all_month_payments_by_employees($comp=NULL,$month=NULL)
    {
        $this->db->select('p.EmpNo,p.salaryPayableRound,e.EmpName,e.Bank,e.AccountNo,e.IDNo');
        $this->db->from("payslip AS p");
        $this->db->join('employee AS e', 'p.Comp = e.Comp AND p.EmpNo=e.EmpNo','left');
        $this->db->where('p.Month',$month);
        $this->db->where('p.Comp',$comp);
        $this->db->where('e.Comp',$comp);
        $this->db->order_by('e.EmpNo','ASC');
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            $data = array();
            foreach($query->result() as $row){
                $data[] = $row;
            }
            return $data;
        }
        else
        {
            return false;
        }
    }

    public function get_month_salary_summary($comp=NULL,$month=NULL)
    {
        $this->db->select('SUM(BasicSalary) as BasicSalary');
        $this->db->select('SUM(Allowance) as Allowances');
        $this->db->select('SUM(Deduction) as Deductions');
        $this->db->select('SUM(TotalSalary) as TotalSalary');
        $this->db->select('SUM(GrossSalary) as GrossSalary');
        $this->db->select('SUM(salaryPayable) as salaryPayable');
        $this->db->select('SUM(salaryPayableRound) as salaryPayableRound');
        $this->db->select('SUM(Nopay) as Nopay');
        $this->db->select('SUM(CCF) as CCF');
        $this->db->from('payslip');
        $this->db->where('Month', $month);
        $this->db->where('Comp', $comp);
        $payslip = $this->db->get();
        $payslip_a = array();
        if ($payslip->num_rows() > 0) {
            $payslip_a = $payslip->row();
        }

        $q = "SELECT 
    SUM(CASE WHEN Code = 'AA' AND Id='A' AND Type='A' THEN Amount ELSE NULL END) AS AttnAllowance,
    SUM(CASE WHEN Code IN ('004-A', '005-A') AND Id='A' AND Type='AB' THEN Amount ELSE NULL END) AS BR,
    SUM(CASE WHEN Code ='BA' AND Id='A' AND Type='A' THEN Amount ELSE NULL END) AS Bonus,
    SUM(CASE WHEN Code ='CBF' AND Id='A' AND Type='A' THEN Amount ELSE NULL END) AS CBF,
    SUM(CASE WHEN Code ='TA' AND Id='A' AND Type='A' THEN Amount ELSE NULL END) AS Telephone,
    SUM(CASE WHEN Code ='SPA' AND Id='A' AND Type='A' THEN Amount ELSE NULL END) AS SpecialAllowance,
    SUM(CASE WHEN Code ='SA' AND Id='A' AND Type='A' THEN Amount ELSE NULL END) AS StarAllowance,
    SUM(CASE WHEN Code ='FA' AND Id='A' AND Type='A' THEN Amount ELSE NULL END) AS Fuel,
    SUM(CASE WHEN Code ='003-A' AND Id='A' AND Type='A' THEN Amount ELSE NULL END) AS OtherAllowances,  
    SUM(CASE WHEN Code ='SD' AND Id='D' AND Type='D' THEN Amount ELSE NULL END) AS SalaryAdvance,
    SUM(CASE WHEN Code ='OD' AND Id='D' AND Type='D' THEN Amount ELSE NULL END) AS OtherDeduction,
    SUM(CASE WHEN Code ='MD' AND Id='D' AND Type='D' THEN Amount ELSE NULL END) AS MealDeduction,
    SUM(CASE WHEN Code ='ID' AND Id='D' AND Type='D' THEN Amount ELSE NULL END) AS Insurance,
    SUM(CASE WHEN Code ='DD' AND Id='D' AND Type='D' THEN Amount ELSE NULL END) AS DeathDeducton,
    SUM(CASE WHEN Code ='DD' AND Id='D' AND Type='D' THEN Amount ELSE NULL END) AS EPF,
    SUM(CASE WHEN Code ='WD' AND Id='D' AND Type='D' THEN Amount ELSE NULL END) AS Welfare,
    SUM(CASE WHEN Code ='NP' AND Id='N' AND Type='DB' THEN Amount ELSE NULL END) AS Nopay,
    SUM(CASE WHEN Code ='NOT' AND Id='O' AND Type='A' THEN Amount ELSE NULL END) AS Nothr,
    SUM(CASE WHEN Code ='DOT' AND Id='O' AND Type='A' THEN Amount ELSE NULL END) AS Dothr,

    SUM(CASE WHEN Code ='ETF' AND Type='OB' THEN Amount ELSE NULL END) AS ETF,
    SUM(CASE WHEN Code ='EPFEM' AND Type='OB' THEN Amount ELSE NULL END) AS EPFEM
FROM payslip_options
WHERE Month = '".$month."'
AND Comp = 'MA'";

        $payslip_option = $this->db->query($q);
        $payslip_option_a = array();
        if ($payslip_option->num_rows() > 0) {
            $payslip_option_a = $payslip_option->row();
        }
        $c[] = (object)array_merge((array)$payslip_a, (array)$payslip_option_a);
        return $c;
    }

    public function getSalaryDetails($comp=NULL,$month=NULL,$dep='')
    {
        $this->db->select('p.*,IF(e.EPFNo != "",e.EPFNo,e.EmpNo) AS EmpNo');
        $this->db->from("payslip AS p");
        $this->db->join('employee AS e', 'p.Comp = e.Comp AND p.EmpNo=e.EmpNo','left');
        $this->db->where('p.Month',$month);
        $this->db->where('p.Comp',$comp);
        if(!empty($dep) ) $this->db->where('e.Dep_code',$dep);
        $this->db->order_by('ABS(p.EPFNo),ABS(p.EmpNo) ASC',FALSE);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            $data = array();
            foreach($query->result() as $row){
                $data[] = $row;
            }
            return $data;
        }
        else
        {
            return false;
        }
    }
    

    public function getPayslip($month=NULL,$emp=0)
    {
        $this->db->select('*');
        $this->db->from("payslip AS p");
        $this->db->where('p.Month',$month);
        //if($comp) $this->db->where('p.Comp',$comp);
        if($emp!=0) $this->db->where('p.EmpNo',$emp);
        $this->db->order_by('ABS(p.EPFNo),ABS(p.EmpNo) ASC',FALSE);
        $query = $this->db->get();
        //echo $this->db->last_query(); die();
        if($query->num_rows() > 0)
        {
            $data = array();
            foreach($query->result() as $row){
                $data[] = $row;
            }
            return $data;
        }
        else
        {
            return false;
        }
    }

    public function addPayslip($data = array(),$loans = array(), $month=NULL,$comp=NULL)
    {
        if ($this->db->delete('payslip', array('Comp' => $comp,'Month'=>$month))) {
            if(!empty($data))
                $this->db->insert_ignore_batch('payslip', $data);
            
        }

        if(!empty($loans)){
            foreach ($loans as $row){

                $where = array();
                $where['month'] = $row['month'];
                $this->db->from('loan_payments');
		        $this->db->where($where);
		        $query = $this->db->get();
                if($query->num_rows()==1)
                {
                    
                }
                else
                {
                    $this->db->where($where);
                    $this->db->insert('loan_payments', $row);
                    $loan_data = array(
                        'InsCount' => $data['LoanInsCount'],
                        'InsAmount' => $data['LoanInsAmount'],
                    );
                    $this->db->where('Id',$data['LoanId']);
                    $this->db->update('loan', $loan_data);
                }
                
            }
        }
        return true;
    }

    public function addPayslip_old($data = array(), $month=NULL,$comp=NULL,$payslip_option=array())
    {
        if ($this->db->delete('payslip', array('Comp' => $comp,'Month'=>$month))) {
            if($this->db->delete('payslip_options', array('Comp' => $comp,'Month'=>$month)))
            {
                $this->db->insert_ignore_batch('payslip', $data);
                $this->db->insert_ignore_batch('payslip_options', $payslip_option);
                return true;
            }
            
            return false;
        }
        return false;
    }

    public function editPayslip($data = array(), $where=array())
    {
        if ($this->db->delete('payslip', $where)) {
            return $this->db->insert('payslip', $data);
        }
        return false;
    }

    public function previous_month_coins($comp=null,$month=null)
    {
        $this->db->select('Amount,EmpNo');
        $this->db->from("trans");
        $this->db->where("Comp",$comp);
        $this->db->where("month",$month);
        $this->db->where("Id_Item",'C');
        $this->db->where("Item_Code",'CCF');
        $query = $this->db->get();
        $data = array();
        if($query->num_rows() > 0)
        {
            foreach($query->result() as $row){
                $data[$row->EmpNo] = $row->Amount;
            }
        }
        return $data;
    }

    public function add_month_coins($comp=null,$month=null,$coins=array())
    {
        $this->db->where("Comp",$comp);
        $this->db->where("month",$month);
        $this->db->where("Id_Item",'C');
        $this->db->delete('trans');
        if(!empty($coins)){
            if($this->db->insert_ignore_batch('trans',$coins))
            {
                return true;
            }
        }
        return false;
    }
	
	function get_leave_days($year)
    {
        $this->db->select('EmpNo,Leave_Code,Days,Balance');
        $this->db->from('leave_year_applied');
        $this->db->where_in('Leave_code',array('0002','0003'));
        $this->db->where('Year', $year);
        $this->db->where('Comp_Id', $this->attn->getComp());
        $this->db->order_by('EmpNo');
        $query = $this->db->get();
		$records = array();
		//echo '<pre>',print_r($query->result());die();
        if($query->num_rows()>0)
        {
			foreach($query->result() as $row){
			    $records[$row->EmpNo][$row->Leave_Code] = $row;
			}
        }
        return $records;
    }

}

?>