<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Sales_Rep_Issue2 extends CI_Controller {

    var $main_menu_name = "sales_rep_issue";
	var $sub_menu_name = "sales_rep_issue";

	public function __construct()
	{
		parent::__construct();

		$this->load->model('Sales_Rep_Issue_Model');
		$this->load->model('Supplier_Model');
		$this->load->model('Warehouse_Model');
		$this->load->model('Common_Model');
		$this->load->model('Tax_Rates_Model');
		$this->load->model('Customer_Model');
		$this->load->model('Sales_Return_Model');
		$this->load->model('User_Model');
		$this->load->model('Transfer_Model');
		$this->load->model('Purchases_Model');
		$this->load->model('Product_Damage_Model');
		//$this->load->model('Sales_Rep_Model');	
		//$this->load->model('Purchases_Model');
		
	}
	
	//Sales list page load
	public function index()
	{
		
		$data['sales_rep_issues']=$this->Sales_Rep_Issue_Model->get_all_sales_rep_issue();
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = $this->sub_menu_name;
        $this->load->view('sales_rep_issue',$data);
	}	
	
	
	public function manage()
	{	
		$sale_rep_issue_id =  $this->uri->segment(3);	
					
		if ($sale_rep_issue_id==0)
		{
			
		$data['warehouse_list']=$this->Warehouse_Model->get_all_warehouse();
		$data['sales_rep_list']=$this->User_Model->get_all_sales_user_reps();
		$data['type']='A';
		$data['main_menu_name']=$this->main_menu_name;
		$data['sub_menu_name']='manage';
		$this->load->view('sales_rep_issue_manage',$data); 		
		}
		else
			{
			
			$data['sale_rep_issue_id']=$this->$sale_rep_issue_id =  $this->uri->segment(3);
			
			$data['warehouse_list']=$this->Warehouse_Model->get_all_warehouse();
			$data['sales_rep_list']=$this->User_Model->get_all_sales_user_reps();
			
			$data['type']='E';
			$data['type1']=$sale_rep_issue_id;
			$data['main_menu_name']=$this->main_menu_name;
			$data['sub_menu_name']='manage';
			$data['sales_rep_issue_details']=$this->Sales_Rep_Issue_Model->get_sales_detail_by_sales_rep_issue_id($sale_rep_issue_id);
			$data['sales_rep_issue_items_details']=$this->Sales_Rep_Issue_Model->get_sale_rep_issue_item_list_by_sale_id($sale_rep_issue_id);
			$this->load->view('sales_rep_issue_manage',$data); 
			
			}
		
	}
	
	function get_all_rep_issue_by_rep_issue_id()
	{
		$sale_rep_issue_id=$this->input->get('SI');
		
		$sale_rep=$this->Sales_Rep_Issue_Model->get_sales_rep_id($sale_rep_issue_id);
		$warehouse=$this->Sales_Rep_Issue_Model->get_warehouse_id_and_date($sale_rep_issue_id);
		$sales_rep_id=$sale_rep['sales_rep_id'];
		$wharehouse_id=$warehouse['wharehouse_id'];
		$sales_rep_issue_date=$warehouse['sales_rep_issue_date'];
		$sale_rep_issue_items=$this->Sales_Rep_Issue_Model->get_sale_rep_issue_item_list_by_sale_id($sale_rep_issue_id);
		
		$json=array();
		
		foreach ($sale_rep_issue_items as $row)
		{
			$product_id= $row['product_id'];
			
			$sales_qty=$this->Sales_Rep_Issue_Model->get_sale_rep_invoice_item_qty($product_id, $sales_rep_id, $wharehouse_id, $sale_rep_issue_id);
		
		if(is_null($sales_qty['quantity']))
						{
						$sales_qty_val=0;
						}
						else
						{
							$sales_qty_val=$sales_qty['quantity'];
						}
		
		 $json_itm=array(
			 		
					'product_id'=> $row['product_id'],
					'product_code'=> $row['product_code'],
					'add_sales_excess_price'=> $row['add_sales_excess_price'],
					'add_sales_discount_price'=> $row['add_sales_discount_price'],
					'product_price'=> $row['product_price'],
					'product_cost'=> $row['product_cost'],
					'salse_rep_issue_qty'=> $row['salse_rep_issue_qty'],
					'product_name'=> $row['product_name'],
					'product_oem_part_number'=> $row['product_oem_part_number'],
					'product_part_no'=> $row['product_part_no'],
					//'item_cost'=> $row['item_cost'],
					'sale_qty'=> $sales_qty_val,
					            
                    );
					//print_r($json_itm);
		
		array_push($json,$json_itm);
						
		}		
		
		echo json_encode($json);		
			
		
		
	}
	
	
	
		function sales_rep_return()
	{
		$sale_rep_issue_id =  $this->uri->segment(3);	
		$data['sale_rep_issue_id']=$this->$sale_rep_issue_id =  $this->uri->segment(3);
			
			$data['warehouse_list']=$this->Warehouse_Model->get_all_warehouse();
			$data['sales_rep_list']=$this->User_Model->get_all_sales_user_reps();
			
			$data['type']='E';
			$data['type1']=$sale_rep_issue_id;
			$data['main_menu_name']=$this->main_menu_name;
			$data['sub_menu_name']='manage';
			$data['sales_rep_issue_details']=$this->Sales_Rep_Issue_Model->get_sales_detail_by_sales_rep_issue_id($sale_rep_issue_id);
			$data['sales_rep_issue_items_details']=$this->Sales_Rep_Issue_Model->get_sale_rep_issue_item_list_by_sale_id($sale_rep_issue_id);
			
			if($data['sales_rep_issue_items_details'])
			$this->load->view('sales_rep_issue_return',$data);
			
			else show_404();
			
			 
		
	}
	
	
	
	public function get_next_ref_no()
	{
	
	$query=$this->Sales_Rep_Issue_Model->get_next_ref_no();
	$result=$query->row();
	$sales_rep_issue_next_ref_number=sprintf("%05d", $result->sales_rep_issue_id+1);
	echo json_encode (array('sales_rep_issue_next_ref_number'=>$sales_rep_issue_next_ref_number));
		
	}
	
	public function get_product_suggestion()
	{
		
		$term=$this->input->get('term');
		$data['product']=$this->Sales_Rep_Issue_Model->get_product_suggestion($term);
		$in_type=$this->input->get('t');
		
		$json=array();
		
		foreach ($data['product'] as $row)
		{
		 $product_id=$row['product_id'];
		 $product_code =$row['product_code'];
		 $product_name=$row['product_name'];
		 $product_oem_part_number=$row['product_oem_part_number'];
		 $product_part_no=$row['product_part_no'];
		 $product_cost=$row['product_cost']; 
		 $product_price=$row['product_price'];
		 $wholesale_price=$row['wholesale_price']; 
		 $credit_salling_price=$row['credit_salling_price'];
		 $sendParameters="$product_id,$product_name,$product_code,$product_price";
		 $selling_R_price=" Selling Price: ".number_format($product_price, 2, '.', ',').' Cost Price:'.number_format($product_cost, 2, '.', ',');//RETAIL PRICE
		 $selling_W_price=" Selling Price(Wholesale): ".number_format($wholesale_price, 2, '.', ',');//WHOLESALE PRICE
		 $selling_C_price=" Selling Price(Credit): ".number_format($credit_salling_price, 2, '.', ',');//CREDIT PRICE
		 if($product_part_no) $selling_R_price.=", Part No: $product_part_no";
		 if($product_oem_part_number) $selling_R_price.=", OEM Part No: $product_oem_part_number";
		
		 $json_itm=array(
			 		'id'=> $row['product_id'],
					'product_id'=> $row['product_id'],
					'product_code'=> $row['product_code'],
					'product_name'=> $row['product_name'],
					'product_price'=> $row['product_price'],
					'product_part_no'=> $row['product_part_no'],
					'item_cost'=> $row['product_cost'],
					'product_oem_part_number'=> $row['product_oem_part_number'],
                    'value'=> $row['product_name']." (".$row['product_code'].")",
                    'label'=> $row['product_name']." (".$row['product_code'].")$selling_R_price"
                    );
		
		array_push($json,$json_itm);
						
		}		
		echo json_encode($json);		
		

		
	}
	
	
	function save_sales_rep_issue()
	{	
		$query=$this->Sales_Rep_Issue_Model->get_next_ref_no();
		$result=$query->row();
		$sales_rep_issue_next_ref_number=sprintf("%05d", $result->sales_rep_issue_id+1);
	    
		$warehouse_id=$this->input->post('warehouse_id');
		$sales_rep_id=$this->input->post('sales_rep_id');
		$secondry_sales_rep_id=$this->input->post('secondry_sales_rep_id');
		
		if($secondry_sales_rep_id)
		{
			
		}
		else
		{
			$secondry_sales_rep_id=-1;
		}
		
		$temp_date=$this->input->post('sales_rep_issue_datetime');
		$add_sales_excess_price=$this->input->post('item_price_p_1');
		$add_sales_discount_price=$this->input->post('discount_1');
		$sales_rep_issue_date=date('Y-m-d', strtotime($temp_date));
		$added_date_time =date('Y-m-d H:i:s');
		$last_modified_date_time=date('Y-m-d H:i:s');
		$total_amount=$this->input->post('sale_total');
		$route_id=$this->input->post('route_id');
		$status="TOBELOAD";
		$sales_rep_issue_id=$this->input->post('sale_reference_no');
		
		
		if($sales_rep_issue_id!=0)
		{
		$sales_rep_issue_next_ref_number=sprintf("%05d", $sales_rep_issue_id);
		}
		
		
		$error='';
		
		if(!$error)
		{
		$data=array(
		
			
			
			'sales_rep_issue_ref_no'=>$sales_rep_issue_next_ref_number,
			
		 	'route_id'=>$route_id,
			'wharehouse_id'=>$warehouse_id,
			'sales_rep_id'=>$sales_rep_id,
			'secondry_sale_rep_id'=>$secondry_sales_rep_id,
			'sales_rep_issue_date'=>$sales_rep_issue_date,
			'added_date_time'=>$added_date_time,
			'total_amount'=>$total_amount,
			'status'=>$status,
			
			'entered_user_id'=>$this->session->userdata('ss_user_id')
			
			);
			$_insert=$this->Sales_Rep_Issue_Model->save_sales_rep_issue($data,$sales_rep_issue_id);
			$lastid=$this->db->insert_id();
			
			
			if($sales_rep_issue_id==0)
				{
				$sales_rep_issue_id=$lastid;
				
				}
				else
				{
				$sales_rep_issue_id;
				$this->Sales_Rep_Issue_Model->delete_old_sales_rep_issue_items($sales_rep_issue_id);
				}

			
			
			
			
			//insert user activity
			$this->Common_Model->add_user_activitie("Added Sales Rep Issue, (Sales Rep Issue No:$sales_rep_issue_next_ref_number)");
			$disMsg='Sale successfully added';
			
			
			$row=$this->input->post('row');
			$rowCount=$this->input->post('rowCount');
			$data_items =array();
			
			for($i=1; $i<=$rowCount; $i++){
				
				if(isset($row[$i]['product_id'][0]))
				{					
				$data_item=array(
					
					'sales_rep_issue_id'=>$sales_rep_issue_id,
					'product_id'=>$row[$i]['product_id'][0],
					'salse_rep_issue_qty'=>$row[$i]['qty'][0],
					'product_price'=>$row[$i]['unit_price'][0],
					'product_cost'=>$row[$i]['item_cost'][0],				
					'add_sales_excess_price'=>$row[$i]['item_price_p'][0],
					'add_sales_discount_price'=>$row[$i]['discount_val'][0],
				);
				$this->Sales_Rep_Issue_Model->save_sales_rep_issue_item($data_item);
				$itemid=$this->db->insert_id();
				
				
				}
			}			
			 	
			
			
		}else {
			
			$disMsg='Please select these before adding any product:'.$disMsg;
		}	
		
		$this->session->set_flashdata('message', 'Sale successfully added!');
		
		echo json_encode(array('sales_rep_issue_id'=>$lastid,'error'=>$error,'disMsg'=>$disMsg,));
		
		
		
		
		
	}
	
	
	
	
	function save_sales_rep_issue_return()
	{	
		$query=$this->Sales_Rep_Issue_Model->get_next_return_ref_no();
		$result=$query->row();
		$sales_rep_issue_next_ref_return_number=sprintf("%06d", $result->sales_rep_issue_return_id+1);
	    
		$warehouse_id=$this->input->post('warehouse_id');
		$sales_rep_id=$this->input->post('sales_rep_id');
		$temp_date=$this->input->post('sales_rep_issue_datetime');
		$sales_rep_issue_id=$this->input->post('sale_reference_no');
		$total_amount=$this->input->post('sale_total');
		$total_cost=$this->input->post('cost_total');
		
		$add_sales_excess_price=$this->input->post('item_price_p_1');
		$add_sales_discount_price=$this->input->post('discount_1');
		$sales_rep_issue_retun_date=date('Y-m-d', strtotime($temp_date));
		$added_date_time =date('Y-m-d H:i:s');
		$last_modified_date_time=date('Y-m-d H:i:s');
		
		$status="returned";
		
		
		
		if($sales_rep_issue_id!=0)
		{
		$sales_rep_issue_next_ref_number=sprintf("%06d", $sales_rep_issue_id);
		}
		
		
		$error='';
		
		if(!$error)
		{
		$data=array(
		
			
			
			'sales_rep_issue_return_ref_no'=>$sales_rep_issue_next_ref_return_number,
			'sales_rep_issue_id 
'=>$sales_rep_issue_id,
			'wharehouse_id'=>$warehouse_id,
			'sales_rep_id'=>$sales_rep_id,
			'sales_rep_issue_date'=>$sales_rep_issue_retun_date,
			'added_date_time'=>$added_date_time,
			'total_amount'=>$total_amount,
			'total_return_cost'=>$total_cost,
			'status'=>$status,
			
			'entered_user_id'=>$this->session->userdata('ss_user_id')
			
			);
			$_insert=$this->Sales_Rep_Issue_Model->save_sales_rep_issue_retrurn($data,$sales_rep_issue_id);
			$lastid=$this->db->insert_id();
			
			//print_r($lastid);
			
		
			
			//insert user activity
			$this->Common_Model->add_user_activitie("Added Sales Rep Issue Return, (Sales Rep Issue No:$sales_rep_issue_next_ref_return_number)");
			$disMsg='Return successfully added';
			
			
			$row=$this->input->post('row');
			$rowCount=$this->input->post('rowCount');
			$data_items =array();
			
			for($i=1; $i<=$rowCount; $i++){
				
				if(isset($row[$i]['product_id'][0]))
				{					
				$data_item=array(
					
					'sales_rep_issue_return_id'=>$lastid,
					'product_id'=>$row[$i]['product_id'][0],
					'salse_rep_issue_qty_r'=>$row[$i]['qty'][0],
					'product_price_r'=>$row[$i]['unit_price'][0],
					'product_cost_r'=>$row[$i]['item_cost'][0],				
					'add_sales_excess_price_r'=>$row[$i]['item_price_p'][0],
					'add_sales_discount_price_r'=>$row[$i]['discount_val'][0],
					'sales_rep_retuned_qty'=>$row[$i]['qty_return'][0],
				);
				$this->Sales_Rep_Issue_Model->save_sales_rep_issue_item_return($data_item);
				$itemid=$this->db->insert_id();
				$this->Sales_Rep_Issue_Model->save_sales_rep_issue_retrurn_complte($sales_rep_issue_id);
				
				
				}
			}			
			 	
			
			
		}else {
			
			$disMsg='Please select these before adding any product:'.$disMsg;
		}	
		
		$this->session->set_flashdata('message', 'Return successfully added!');
		
		echo json_encode(array('sales_rep_issue_id'=>$lastid,'error'=>$error,'disMsg'=>$disMsg,));
		
		
		
		
	}
	
	
	
	
	
	
	
	
	
	
	
	
	public function sales_rep_issue_details()
	{
		
		$sale_rep_issue_id =  $this->uri->segment(3);
		$rep_id=$this->Sales_Rep_Issue_Model->get_sales_detail_by_sales_rep_issue_id($sale_rep_issue_id);
		$whare_id=$this->Sales_Rep_Issue_Model->get_sales_detail_by_sales_rep_issue_id($sale_rep_issue_id);
		$rep_id=$this->Sales_Rep_Issue_Model->get_sales_detail_by_sales_rep_issue_id($sale_rep_issue_id);
		
		$sales_rep_id=$rep_id['sales_rep_id'];
		$id=$whare_id['wharehouse_id'];
		
		$data['SRID']=$sale_rep_issue_id;
		$data['main_menu_name']=$this->main_menu_name;
		$data['sub_menu_name']='';
		$data['wharehose_details']=$this->Warehouse_Model->get_warehouse_info($id);
		$data['sales_rep_details']=$this->User_Model->get_rep_first_and_second_name_by_id($sales_rep_id);
		$data['sales_rep_issue_details']=$this->Sales_Rep_Issue_Model->get_sales_detail_by_sales_rep_issue_id($sale_rep_issue_id);
		$data['sales_rep_issue_items_details']=$this->Sales_Rep_Issue_Model-> get_sale_rep_issue_item_list_by_sale_id($sale_rep_issue_id);	
		
		 $this->load->view('sales_rep_issue_details',$data);	
	}
	
	
	public function sales_rep_issue_details_print()
	{
		$data['main_menu_name']=$this->main_menu_name;
		$data['sub_menu_name']='';
		$sale_rep_issue_id=$this->input->get('sale_rep_issue_id');
		$rep_id=$this->Sales_Rep_Issue_Model->get_sales_detail_by_sales_rep_issue_id($sale_rep_issue_id);
		$whare_id=$this->Sales_Rep_Issue_Model->get_sales_detail_by_sales_rep_issue_id($sale_rep_issue_id);
		$rep_id=$this->Sales_Rep_Issue_Model->get_sales_detail_by_sales_rep_issue_id($sale_rep_issue_id);
		
		$sales_rep_id=$rep_id['sales_rep_id'];
		$id=$whare_id['wharehouse_id'];
		
		$data['SRID']=$sale_rep_issue_id;
		$data['main_menu_name']=$this->main_menu_name;
		$data['sub_menu_name']='';
		$data['wharehose_details']=$this->Warehouse_Model->get_warehouse_info($id);
		$data['sales_rep_details']=$this->User_Model->get_rep_first_and_second_name_by_id($sales_rep_id);
		$data['sales_rep_issue_details']=$this->Sales_Rep_Issue_Model->get_sales_detail_by_sales_rep_issue_id($sale_rep_issue_id);
		$data['sales_rep_issue_items_details']=$this->Sales_Rep_Issue_Model-> get_sale_rep_issue_item_list_by_sale_id($sale_rep_issue_id);	
		 
		 $this->load->view('models/sales_rep_issue_details_print',$data);
	}
	
	
	
	public function list_sales_rep_issue()
	{	
	
	$data=array();
	
	$sales_rep_issue=$this->Sales_Rep_Issue_Model->get_all_sales_rep_issue();
	
	foreach ( $sales_rep_issue as $row)
	{
		$sales_rep_issue_id=$row['sales_rep_issue_id'];
		
		$pay_st = '<span class="label label-danger">Error</span>';
		
		if($row['status']=="COMPLETED")
		{
			$pay_st = '<span class="label label-success">Completed</span>';	
			$action='<div class="btn-group text-left">
                       
					        <button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button>
                            <ul role="menu" class="dropdown-menu pull-right">
                            <li><a href="'.base_url().'sales_rep_issue2/sales_rep_issue_details/'.$sales_rep_issue_id.'"><i class="fa fa-file-text-o"></i> Sale Rep Issue Details</a></li>
							
							
                            </ul></div>';
			
		}
		else
		{
			if($row['status']=="TOBELOAD")
			{
			$pay_st = '<span class="label label-warning">Pending</span>';	
			$action='<div class="btn-group text-left">
                       
					        <button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button>
                            <ul role="menu" class="dropdown-menu pull-right">
                            <li><a href="'.base_url().'sales_rep_issue2/sales_rep_issue_details/'.$sales_rep_issue_id.'"><i class="fa fa-file-text-o"></i> Sale Rep Issue Details</a></li>
							<li><a href="'.base_url().'sales_rep_issue2/manage/'.$sales_rep_issue_id.'"><i class="fa fa-file-text-o"></i> Sale Rep Issue Edit</a></li>
							<li><a href="'.base_url().'sales_rep_issue2/sales_rep_return/'.$sales_rep_issue_id.'"><i class="fa fa-file-text-o"></i> Sale Rep Issue Return</a></li>
							
                            </ul></div>';
			}
			else
			{
			
			$pay_st = '<span class="label label-danger">Error</span>';
			}
			
			
		}
		
		
		
		$nestedData=array();
		
		//print_r($sales_rep_issue_id);
		$nestedData[]=$row['sales_rep_issue_date'];
		$nestedData[]=$row['sales_rep_issue_ref_no'];
		$nestedData[]=$row['user_first_name'];
		$nestedData[]=$row['total_amount'];
		$nestedData[]=$pay_st;
		$nestedData[]=$action;
	
		$data[]=$nestedData;
	}	
	
	
	$json_data = array(
	"data"=>$data
	);
	
	echo json_encode($json_data);
	
		
	}
	
	
	
}