<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Common extends CI_Controller {

	public function __construct()
	{
		parent::__construct();

		$this->load->model('Common_Model');
	}
	
	public function index()
	{
		

	}
	
	public function get_all_country(){
		$data['country_list'] = $this->Cupplier_Model->get_all_country();
	}

	public function get_all_status(){
		$data['status_list'] = $this->Common_Model->get_all_status();
	}	

    function get_store_note(){
		$whid = $this->input->post('warehouse_id');
		$rslt = $this->Common_Model->gen_stn_number($whid);
		$rtn = array('stn_no' =>$rslt['stn_no'],'stn_code' =>$rslt['stn_code']);
		echo json_encode($rtn);		
	}
	
	function add_menu(){
	    $data['main_menu_name']="common";
	    $data['sub_menu_name']="add_page";
	    $data['menu_list'] = $this->Common_Model->list_menu();
        $this->load->view('common/add_menu', $data);
	}
	
	function save_menu(){
        $this->load->library('form_validation'); //form validation lib
        $this->form_validation->set_rules('menu_name', 'Menu Name', 'required');
        $this->form_validation->set_rules('menu_display_name', 'Product Display Name', 'required');
        if ($this->form_validation->run() == FALSE) {
            $st = array(
                'status' => 0,
                'validation' => validation_errors()
            );
            echo json_encode($st);
        } else {
            $menu_name = $this->input->post('menu_name');
            $menu_display_name = $this->input->post('menu_display_name');
            $menu_parent_id = $this->input->post('menu_parent_id');
            $menu_url = $this->input->post('menu_url');
            $menu_status = $this->input->post('menu_status');
            
            $pd = array(
                'menu_name' => $menu_name,
                'menu_display_name' => $menu_display_name,
                'menu_parent_id' => $menu_parent_id,
                'menu_url' => $menu_url,
                'menu_status' => $menu_status
            );

            $last_id    = $this->Common_Model->save_menu($pd);
            
            // permission allocation
            if($last_id){
                $gpt = $this->Common_Model->get_permission_types();
                $ugp = $this->Common_Model->get_user_groups();
                
                foreach($ugp as $rugp){
                    foreach($gpt as $ugpt){
                        $prm = 0;
                        if($rugp['user_group_id'] == 1 || $rugp['user_group_id'] == 2)$prm = 1;
                        $rule = array(
                            'menu_id' => $last_id,
                            'group_id' => $rugp['user_group_id'],
                            'gp_id' => $ugpt['usrgp_permission_id'],
                            'has_permission' => $prm
                        );
                        $this->Common_Model->add_rule($rule);
                    }
                }
            }
            // end permission allocation
            if ($last_id) {
                $st = array(
                    'status' => 1,
                    'validation' => 'Done!',
                    'last_id' => $last_id
                );
                echo json_encode($st);
            } else {
                $st = array(
                    'status' => 0,
                    'validation' => 'error occurred please contact your system administrator'
                );
                echo json_encode($st);
            }
        }
    }
    
    // demo permission allocation
    
    function allow_all(){
        $menu= $this->Common_Model->list_menu();
        $gpt = $this->Common_Model->get_permission_types();
        $ugp = $this->Common_Model->get_user_groups();
        
        foreach($menu as $mnu){
            foreach($ugp as $rugp){
                foreach($gpt as $ugpt){
                    $prm = 0;
                    if($rugp['user_group_id'] == 1 || $rugp['user_group_id'] == 2)$prm = 1;
                    $rule = array(
                        'menu_id' => $mnu['menu_id'],
                        'group_id' => $rugp['user_group_id'],
                        'gp_id' => $ugpt['usrgp_permission_id'],
                        'has_permission' => $prm
                    );
                    if($this->Common_Model->add_rule($rule)){
                        echo "<pre>";
                        print_r($rule);
                        echo "Permission rule added.<br>";
                        echo "</pre>";
                    }
                    
                }
            }
        }
    }

}