<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
    include('core_production_preparation_model.php');
class Production_Preparation_Model extends Core_Production_Preparation_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->db->query("SET sql_mode=(SELECT REPLACE(@@sql_mode, 'ONLY_FULL_GROUP_BY', ''));");
    }
    /* standard function */
    public function runSaveMaster($data){
        return $this->saveMaster($data);
    }
    public function runSaveItems($data){
        return $this->saveItems($data);
    }
    public function runSaveSubItems($data){
        return $this->saveSubItems($data);
    }
    public function runUpdateMasterUsingPrimaryId($id,$data){
        return $this->updateMasterUsingPrimaryId($id,$data);
    }
    public function runUpdateItemsUsingPrimaryId($id,$data){
        return $this->updateItemsUsingPrimaryId($id,$data);
    }
    public function runUpdateSubItemsUsingPrimaryId($id,$data){
        return $this->updateSubItemsUsingPrimaryId($id,$data);
    }
    public function runDeleteMasterUsingPrimaryId($id){
        return $this->deleteMasterUsingPrimaryId($id);
    }
    public function runDeleteItemsUsingPrimaryId($id){
        return $this->deleteItemsUsingPrimaryId($id);
    }
    public function runDeleteSubItemsUsingPrimaryId($id){
        return $this->deleteSubItemsUsingPrimaryId($id);
    }
    public function runSelectMasterUsingPrimaryId($id){
        return $this->selectMasterUsingPrimaryId($id);
    }
    public function runSelectItemsUsingPrimaryId($id){
        return $this->selectItemsUsingPrimaryId($id);
    }
    public function runSelectSubItemsUsingPrimaryId($id){
        return $this->selectSubItemsUsingPrimaryId($id);
    }
     public function runUpdateMasterUsingSecondaryId($id,$data){
        return $this->updateMasterUsingSecondaryId($id,$data);
    }
    public function runUpdateItemsUsingSecondaryId($id,$data){
        return $this->updateItemsUsingSecondaryId($id,$data);
    }
    public function runUpdateSubItemsUsingSecondaryId($id,$data){
        return $this->updateSubItemsUsingSecondaryId($id,$data);
    }
    public function runSelectMasterUsingSecondaryId($id){
        return $this->selectMasterUsingSecondaryId($id);
    }
    public function runSelectItemsUsingSecondaryId($id){
        return $this->selectItemsUsingSecondaryId($id);
    }
    public function runSelectSubItemsUsingSecondaryId($id){
        return $this->selectSubItemsUsingSecondaryId($id);
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    /*customizable function*/
    
   public function runGetPendingBatch($id,$data){
       return  $this->getPendingBatch($id,$data);
    }
    private function getPendingBatch($id,$data)
    {
       $this->db->select('pbi.* ,u.unit_name,mpt.mpt_name,p.product_code,p.product_name,mtp.mtp_name');
        $this->db->from('production_batch_items pbi');
        $this->db->join('production_batch_master pbm', 'pbi.pbm_id = pbm.pbm_id', 'inner');
        $this->db->join('production_cost_estimation_item pcei', 'pbi.pcei_id = pcei.pcei_id', 'inner');
        $this->db->join('master_time_profile mtp', 'mtp.mtp_id = pcei.time_profile_id', 'inner');
        $this->db->join('product p', 'pbi.pbi_product_id = p.product_id', 'inner');
        $this->db->join('mstr_unit u', 'u.unit_id = p.product_unit', 'inner');
        $this->db->join('master_product_type mpt', 'mpt.mpt_id = p.product_type_id', 'inner');
        $this->db->where("pbi.is_deleted = 0");
        $this->db->where("pbi.pbi_pickup_status = 0");
        $this->db->where("pbm.pbm_warehouse_id",$id);
        $this->db->group_by("pbi.pbi_id");
        $query = $this->db->get();
        return $query->result_array();
    }
   public function runGetSelectedBatch($id,$data){
       return  $this->getSelectedBatch($id,$data);
    }
    private function getSelectedBatch($id,$data)
    {
        $this->db->select('psni.*,pbi.pbi_ref_no,pbi.pbi_qty ,u.unit_name,mpt.mpt_name,p.product_code,p.product_name,psnm.psnm_status');
        $this->db->from('production_store_note_item psni');
        $this->db->join('production_store_note_master psnm', 'psnm.psnm_id = psni.psnm_id', 'inner');
        $this->db->join('production_batch_items pbi', 'pbi.pbi_id = psni.pbi_id', 'inner');
        $this->db->join('product p', 'pbi.pbi_product_id = p.product_id', 'inner');
        $this->db->join('mstr_unit u', 'u.unit_id = p.product_unit', 'inner');
        $this->db->join('master_product_type mpt', 'mpt.mpt_id = p.product_type_id', 'inner');
        $this->db->where("pbi.is_deleted = 0");
        $this->db->where("pbi.pbi_pickup_status = 1");
        $this->db->where("psni.psnm_id",$id);
        $this->db->group_by('psni.psni_id');
        $query = $this->db->get();
        return $query->result_array();
    }
    public function runGetNotCompleteSTNListServerSide($start, $length, $search_key_val,$customer_condition){
       return  $this->getNotCompleteSTNListServerSide($start, $length, $search_key_val,$customer_condition);
    }
    private function getNotCompleteSTNListServerSide($start, $length, $search_key_val,$customer_condition)
    {
        $this->db->select('p.*');
        $this->db->select('w.name AS warehouse_name');
        $this->db->select('um.user_first_name');
        $this->db->from('production_store_note_master p');
        $this->db->join('warehouses w', 'w.id = p.psnm_warehouse_id', 'inner');
        $this->db->join('user um', 'um.user_id = p.psnm_user_id', 'inner');
        $filters='';
        if(isset($customer_condition['id'])){
            $filters.=' AND p.psnm_warehouse_id = '.$customer_condition["id"];
        }
        if ($search_key_val) {
            $this->db->where("p.is_deleted = 0 AND p.psnm_status= 0 AND p.psnm_pickup_status = 0 AND p.psnm_ref_no LIKE '$search_key_val%'".$filters);
		    $this->db->or_where("p.is_deleted = 0 AND p.psnm_status = 0 AND p.psnm_pickup_status = 0 AND p.psnm_manual_ref_no LIKE '%$search_key_val%'".$filters);
        }else{
            $this->db->where("p.is_deleted = 0 AND p.psnm_status = 0 AND p.psnm_pickup_status = 0 ".$filters);
        }
		$this->db->order_by("p.psnm_id", "asc");
        if ($start != '' && $length != '') {
            $this->db->limit($length, $start);
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->result();
            } else {
                return false;
            }
        } else {
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->num_rows();
            } else {
                return false;
            }
        }
    }
    public function runGetSelectedBatchMaterial($id,$data){
       return  $this->getSelectedBatchMaterial($id,$data);
    }
    private function getSelectedBatchMaterial($id,$data)
    {
        $this->db->select('pm.*,u.unit_name,mpt.mpt_name,');
        $this->db->select('psnm.psnm_warehouse_id');
        $this->db->from('product_material pm');
        $this->db->join('production_batch_sub_items pbsi', 'pbsi.pbsi_product_mat_id = pm.product_mat_id', 'inner');
        $this->db->join('production_store_note_sub_items psnsi', 'psnsi.pbsi_id = pbsi.pbsi_id', 'inner');
        $this->db->join('production_store_note_master psnm', 'psnm.psnm_id = psnsi.psnm_id', 'inner');
        $this->db->join('mstr_unit u', 'u.unit_id = pm.product_mat_unit', 'inner');
        $this->db->join('master_product_type mpt', 'mpt.mpt_id = pm.product_mat_type_id', 'inner');
        $this->db->where("psnsi.psnm_id",$id);
        $this->db->group_by('pm.product_mat_id');
        $query = $this->db->get();
        return $query->result_array();
    }
    
     public function runGetSumAllBatchMaterial($id,$data){
       return  $this->getSumAllBatchMaterial($id,$data);
    }
    private function getSumAllBatchMaterial($id,$mstr_id)
    {
        $this->db->select_sum('pbsi.pbis_qty');
        $this->db->from('production_batch_sub_items pbsi');
        $this->db->join('production_store_note_sub_items psnsi', 'psnsi.pbsi_id = pbsi.pbsi_id', 'inner');
        $this->db->where("pbsi.pbsi_product_mat_id",$id);
        $this->db->where("psnsi.psnm_id",$mstr_id);
        $query = $this->db->get();
        $result= $query->row_array();
        if(isset($result['pbis_qty'])){
            return $result['pbis_qty'];
        }else{
            return 0;
        }
    }
    public function runGetBatchSubItem($id){
       return  $this->getBatchSubItem($id);
    }
    private function getBatchSubItem($id)
    {
        $this->db->select('pbsi.*');
        $this->db->from('production_batch_sub_items pbsi');
        $this->db->where("pbsi.pbsi_issue_status",0);
        $this->db->where("pbsi.pbi_id",$id);
        $query = $this->db->get();
        return $query->result_array();
    }
    public function runGetBatchItem($id){
       return  $this->getBatchItem($id);
    }
    private function getBatchItem($id)
    {
        $this->db->select('pbi.*,pbm.pbm_warehouse_id');
        $this->db->from('production_batch_items pbi');
        $this->db->join('production_batch_master pbm', 'pbm.pbm_id = pbi.pbm_id', 'inner');
        $this->db->where("pbi.pbi_pickup_status",0);
        $this->db->where("pbi.pbi_status",1);
        $this->db->where("pbi.prodcution_start_status",0);
        $this->db->where("pbi.pbm_id",$id);
        $query = $this->db->get();
        return $query->result_array();
    }
    
    
    
    
    
     public function runSaveSTNSubItems($data){
       return  $this->saveSTNSubItems($data);
    }
     private function saveSTNSubItems($pd){
        if ($this->db->insert('production_store_note_sub_items', $pd)) {
            $lst = $this->db->insert_id();
            return $lst;
        } else {
            return false;
        }
    }
    
     public function runDeleteSTNSubItemUsingSecondryId($id){
       return  $this->deleteSTNSubItemUsingSecondryId($id);
    }
     private function deleteSTNSubItemUsingSecondryId($id){
        if($id>0){
            $this->db->where('psni_id', $id);
            return $this->db->delete('production_store_note_sub_items');  
        }else{
            return false;
        }
    }
    
    
    
    public function getAllDetails($id)
    {
        $this->db->select('psnm.*,mtp.mtp_name');
        $this->db->from('production_store_note_master psnm');
        $this->db->join('master_time_profile mtp', 'psnm.time_profile_id = mtp.mtp_id', 'inner');
        $this->db->where("psnm.psnm_id",$id);
        $query = $this->db->get();
        return  $query->row_array();
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
  
}